#include "libgccvb.h"
#include "chronorun.c"
#include "chronorun.h"

#define LEFTFRAME 5
#define RIGHTFRAME 5
#define UPFRAME 6
#define DOWNFRAME 6

#define CHARHEIGHT 36
#define CHARWIDTH 18
#define CHARSPACER 6
#define STARTINGFRAME 7

#define LD 1
#define LU 2
#define LL 3
#define LR 4

int main()
{
	
	struct SPRITE {
		int FrameCount;
		int BG_MapX;
		int RedrawRate;
	}ChronoRunUp,ChronoRunDown,ChronoRunLeft,ChronoRunRight,ChronoStandDown,ChronoStandUp,ChronoStandLeft,ChronoStandRight;
	
	int vert=0, horz=0,animframe=8,CHARDIRECTION,CHARFRAME,REDRAW,CHARIDLE,CharFacing;
	
	HWORD controlread;
	
	ChronoRunUp.FrameCount = 6;
	ChronoRunUp.BG_MapX = 46;
	ChronoRunUp.RedrawRate = 290;

	ChronoRunDown.FrameCount = 6;
	ChronoRunDown.BG_MapX = 7;
	ChronoRunDown.RedrawRate = 290;

	ChronoRunLeft.FrameCount = 5;
	ChronoRunLeft.BG_MapX = 126;
	ChronoRunLeft.RedrawRate = 290;

	ChronoRunRight.FrameCount = 5;
	ChronoRunRight.BG_MapX = 86;
	ChronoRunRight.RedrawRate = 290;

	ChronoStandDown.FrameCount = 3;
	ChronoStandDown.BG_MapX = 166;
	ChronoStandDown.RedrawRate = 1400;
	
	ChronoStandUp.FrameCount = 1;
	ChronoStandUp.BG_MapX = 208;
	ChronoStandUp.RedrawRate = 1400;
	
	ChronoStandLeft.FrameCount = 3;
	ChronoStandLeft.BG_MapX = 286;
	ChronoStandLeft.RedrawRate = 1400;
	
	ChronoStandRight.FrameCount = 3;
	ChronoStandRight.BG_MapX = 246;
	ChronoStandRight.RedrawRate = 1400;
	
	CHARDIRECTION=ChronoStandDown.BG_MapX;
	CHARFRAME=ChronoStandDown.FrameCount;
	REDRAW = ChronoStandDown.RedrawRate;
	
	
	vbDisplayOn();

	copymem((void*)CharSeg0, (void*)chronorunTiles, 254*16);
  copymem((void*)CharSeg1, (void*)chronorunTiles, 254*16);
	copymem((void*)BGMap(0), (void*)chronorunMap, 512*16);
	copymem((void*)BGMap(1), (void*)chronorunMap, 512*16);

	vbDisplayShow();
    
	while(1)
	{

		
		 controlread = vbReadPad();
		 
		 CHARIDLE = 1;
		 
		 if (controlread & K_LD){
		 	 vert=vert+6;
		 	 CHARDIRECTION = ChronoRunDown.BG_MapX;
		 	 CHARFRAME = ChronoRunDown.FrameCount;
		 	 REDRAW = ChronoRunDown.RedrawRate;
		 	 CHARIDLE = 0;
		 	 CharFacing = LD;
		 }
		 
		 if (controlread & K_LU){
		 	 vert=vert-6;
		   CHARDIRECTION = ChronoRunUp.BG_MapX;
		 	 CHARFRAME = ChronoRunUp.FrameCount;
		 	 REDRAW = ChronoRunUp.RedrawRate;
		 	 CHARIDLE = 0;
		 	 CharFacing = LU;
		 }
		 
		 if (controlread & K_LL){
		 	horz=horz-6;
			CHARDIRECTION = ChronoRunLeft.BG_MapX;
		  CHARFRAME = ChronoRunLeft.FrameCount;
		  REDRAW = ChronoRunUp.RedrawRate;
		  CHARIDLE = 0;
		  CharFacing = LL;
		 }
		 
		 if (controlread & K_LR){
		 	horz=horz+6;
			CHARDIRECTION = ChronoRunRight.BG_MapX;
		  CHARFRAME = ChronoRunRight.FrameCount;
		  REDRAW = ChronoRunUp.RedrawRate;
		  CHARIDLE = 0;
		  CharFacing = LR;
		 }
		 
		 if (CHARIDLE == 1){
		 	if (CharFacing == LD){
		 		CHARDIRECTION = ChronoStandDown.BG_MapX;
		  	CHARFRAME = ChronoStandDown.FrameCount;
		  	REDRAW = ChronoStandDown.RedrawRate;
		  }
		  else if (CharFacing == LU){
		  	CHARDIRECTION = ChronoStandUp.BG_MapX;
		  	CHARFRAME = ChronoStandUp.FrameCount;
		  	REDRAW = ChronoStandUp.RedrawRate;
		  }
		  else if (CharFacing == LL){
		  	CHARDIRECTION = ChronoStandLeft.BG_MapX;
		  	CHARFRAME = ChronoStandLeft.FrameCount;
		  	REDRAW = ChronoStandLeft.RedrawRate;
		  }
		  else if (CharFacing == LR){
		  	CHARDIRECTION = ChronoStandRight.BG_MapX;
		  	CHARFRAME = ChronoStandRight.FrameCount;
		  	REDRAW = ChronoStandRight.RedrawRate;
		  }
		 }
		 			 		
		

		animframe = animframe + (CHARWIDTH + CHARSPACER);

		if (animframe > ((CHARWIDTH + CHARSPACER) * CHARFRAME)){
			animframe = STARTINGFRAME;
		}
    
	
 		vbSetWorld(31, WRLD_LON, horz, 0, vert, animframe, 0, CHARDIRECTION, CHARWIDTH, CHARHEIGHT);
 		vbSetWorld(30, WRLD_RON|1, horz, 0, vert, animframe, 0, CHARDIRECTION, CHARWIDTH, CHARHEIGHT);
  	vbSetWorld(29, WRLD_END, 0, 0, 0, 0, 0, 0, 0, 0);
  	
  	vbWaitFrame(REDRAW);
  	
  	
  	
	}
}