/*
   "Seiryu" Virtual Boy Library
   (Pronounced: sigh-roo)
   version 1.0 (First gccVB release: Jan. 2003)

   A collaborative effort by:

	Amos Bieler			Slapped it together and inserted the errors ;)
	"frostgiant"			Rekindled my interest in using gccv810 for the VB; translated some veCC routines to C
	Alberto Covarrubias		Made veCC and useful ASM routines; made compiler crappy so this alternative would be needed ;)
	"Parasyte"			RE-translated the veCC routines; made a new crt0; made a new linker script
	David Tucker			Oh, he just STARTED THE WHOLE VB DEVING SCENE!!!!!
	And probably others...	        (You know who you are!)

	BTW, ONLY KIDDING, ALBERTO!!!!  veCC was a valiant attempt!

	You should release the source, so others can learn from (and improve upon) it.

   BTW, "Seiryu" is a variety of Japanese Red-leaf Maple tree...
*/

#ifndef _LIBGCCVB_H_
#define _LIBGCCVB_H_

#define	XPBSYR	0x000C

// Easier to type/remember...
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

typedef signed char s8;
typedef signed short s16;
typedef signed long s32;

typedef unsigned char BYTE;
typedef unsigned short HWORD;
typedef unsigned long WORD;

HWORD* VIP_REGS =		(HWORD*)0x0005F800;
HWORD* BGMM =			(HWORD*)0x00020000;
HWORD* WAM =			(HWORD*)0x0003D800;
HWORD* COLUMN_TABLE =		(HWORD*)0x0003DC00;
HWORD* OAM =			(HWORD*)0x0003E000;

/****** VIP Register Mnemonics ******/
#define INTPND	0x00
#define INTENB	0x01
#define INTCLR	0x02

#define DPSTTS	0x10
#define DPCTRL	0x11
#define BRTA	0x12
#define BRTB	0x13
#define BRTC	0x14
#define REST	0x15

#define FRMCYC	0x17
#define CTA	0x18

#define XPSTTS	0x20
#define XPCTRL	0x21
#define VER	0x22

#define SPT0	0x24
#define SPT1	0x25
#define SPT2	0x26
#define SPT3	0x27

#define GPLT0	0x30
#define GPLT1	0x31
#define GPLT2	0x32
#define GPLT3	0x33

#define JPLT0	0x34
#define JPLT1	0x35
#define JPLT2	0x36
#define JPLT3	0x37

#define BKCOL	0x38

WORD* SND_REGS = (WORD*)0x01000000;

/***** Sound Register Mnemonics *****/
/* none, currently... */

BYTE* HW_REGS = (BYTE*)0x02000000;
/***** Hardware Register Mnemonics *****/
#define	CCR	0x00	// Link Port Control 1
#define	CCSR	0x04	// Link Port Control 2
#define	CDTR	0x08	// Link Port Transmit
#define	CDRR	0x0C	// Link Port Receive
#define	SDLR	0x10	// Keypad Low Byte
#define	SDHR	0x14	// Keypad High Byte
#define	TLR	0x18	// Timer Low Byte
#define	THR	0x1C	// Timer High Byte
#define	TCR	0x20	// Timer Control Register
#define	WCR	0x24	// Wait-state Control Register
#define	SCR	0x28	// Keypad (controller) Control Register

/***** Handy Video RAM Locations *****/
#define	CharSeg0	0x6000
#define	CharSeg1	0xE000
#define	CharSeg2	0x16000
#define	CharSeg3	0x1E000
#define BGMMBase	0x20000
#define BGMap(x)	(BGMMBase+(0x2000*x))
#define World(x)	(0x3D800+(x*0x20))
#define	ObjectSeg	0x3E000
#define	Object(x)	(0x3E000+(8*x))

/***** World Functions *****/
void vbSetWorld (int nw, HWORD header, HWORD gx, HWORD gp, HWORD gy, HWORD mx, HWORD mp, HWORD my, HWORD width, HWORD height) {
		
	HWORD tmp = (nw<<5)>>1;
	
        while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = header;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = gx;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = gp;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = gy;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = mx;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = mp;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = my;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp++] = width;
	while (VIP_REGS[XPSTTS] & XPBSYR); WAM[tmp] = height;
}

/* Macros for world manipulation */
#define WORLD_HEAD(n,head)		WAM[((n << 5) >> 1)    ] = head;
#define WORLD_GSET(n,gx,gp,gy)	WAM[((n << 5) >> 1) + 1] = gx;\
								WAM[((n << 5) >> 1) + 2] = gp;\
								WAM[((n << 5) >> 1) + 3] = gy;
#define WORLD_MSET(n,mx,mp,my)	WAM[((n << 5) >> 1) + 4] = mx;\
								WAM[((n << 5) >> 1) + 5] = mp;\
								WAM[((n << 5) >> 1) + 6] = my;
#define WORLD_SIZE(n,w,h)		WAM[((n << 5) >> 1) + 7] = w;\
								WAM[((n << 5) >> 1) + 8] = h;
#define WORLD_PARAM(n,p)		WAM[((n << 5) >> 1) + 9] = (p << 4);

/* "vbSetWorld" header flags */
/* (OR these together to build a World Header) */

#define	WRLD_ON		0xC000
#define	WRLD_LON	0x8000
#define	WRLD_RON	0x4000
#define	WRLD_OBJ	0x3000
#define	WRLD_AFFINE	0x2000
#define	WRLD_HBIAS	0x1000
#define	WRLD_BGMAP	0x0000

#define	WRLD_1x1	0x0000
#define	WRLD_1x2	0x0100
#define	WRLD_1x4	0x0200
#define	WRLD_1x8	0x0300
#define	WRLD_2x1	0x0400
#define	WRLD_2x2	0x0500
#define	WRLD_2x4	0x0600
#define	WRLD_4x2	0x0900
#define	WRLD_4x1	0x0800
#define	WRLD_8x1	0x0C00

#define	WRLD_OVR	0x0080
#define	WRLD_END	0x0040


/***** Object (sprite) Functions *****/

void vbSetObject (HWORD n, BYTE header, HWORD x, HWORD p, HWORD y, HWORD chr)
{
	HWORD temp1, temp2, signbit;

	signbit=(p & 0x8000) >> 2;

	temp1 = (header & 0xC0) << 8;
	temp2 = (p & 0xFF) | signbit | temp1;

	temp1 = ((header & 0x3C) << 10) | (chr & 0x7FF);

	OAM[n<<2] = x;
	OAM[(n<<2)+1] = temp2;
	OAM[(n<<2)+2] = y;
	OAM[(n<<2)+3] = temp1;
}

/*** (Obsoleted by vbSetObject and the OBJ_* macros...)
void vbObjectMove (int num, int x, int y, int p)
{
	HWORD rmw;

	OAM[(n << 2)] = x;

	rmw = OAM[(n << 2) + 1] & 0xC000;
	OAM[(n << 2) + 1] = rmw | p;

	OAM[(n << 2) + 2] = y;
}
***/

#define OBJ_XSET(n,x)	OAM[n << 2] = x;
#define OBJ_YSET(n,y)	OAM[(n << 2) + 2] = y;
#define OBJ_PSET(n,p)	OAM[(n << 2) + 1] = (OAM[(n << 2) + 1] & 0xC000) | p;
#define OBJ_CSET(n,c)	OAM[(n << 2) + 3] = (OAM[(n << 2) + 3] & 0xF000) | (HWORD)c;
#define OBJ_HSET(n,h)	OAM[(n << 2) + 3] = (OAM[(n << 2) + 3] & 0xDFFF) | (((HWORD)h << 13) & 0x2000);
#define OBJ_VSET(n,v)	OAM[(n << 2) + 3] = (OAM[(n << 2) + 3] & 0xEFFF) | (((HWORD)h << 12) & 0x1000);
// #define OBJ_PALSET(n,pal)
// #define OBJ_VIS(n,v)

/* "vbSetObject" header flags */
/* (OR these together to build an Object Header) */
#define	OBJ_ON		0x00C0
#define	OBJ_LON		0x0080
#define	OBJ_RON		0x0040

#define	OBJ_PAL0	0x0000
#define	OBJ_PAL1	0x0010
#define	OBJ_PAL2	0x0020
#define	OBJ_PAL3	0x0030

#define	OBJ_HFLIP	0x0008
#define	OBJ_VFLIP	0x0004

/* Keypad Definitions */
#define K_ANY	0xFFFC		/* All keys - bat/sgn			*/
#define K_BTNS	0x303C		/* All buttons; no d-pads		*/
#define K_PWR	0x0001		/* Low Battery					*/
#define K_SGN	0x0002		/* Signature; 1 = Standard Pad	*/
#define K_A	0x0004		/* A Button						*/
#define K_B	0x0008		/* B Button						*/
#define K_RT	0x0010		/* R Trigger					*/
#define K_LT	0x0020		/* L Trigger					*/
#define K_RU	0x0040		/* Right Pad, Up				*/
#define K_RR	0x0080		/* Right Pad, Right				*/
#define K_LR	0x0100		/* Left Pad,  Right				*/
#define K_LL	0x0200		/* Left Pad,  Left				*/
#define K_LD	0x0400		/* Left Pad,  Down				*/
#define K_LU	0x0800		/* Left Pad,  Up				*/
#define K_STA	0x1000		/* Start Button					*/
#define K_SEL	0x2000		/* Select Button				*/
#define K_RL	0x4000		/* Right Pad, Left				*/
#define K_RD	0x8000		/* Right Pad, Down				*/

/* Reads the keypad, returns the result in a HWORD */
HWORD vbReadPad (void) {
	HW_REGS[SCR] = 0x84;
	while(HW_REGS[SCR] & 2);
	return (HW_REGS[SDHR] << 8) | HW_REGS[SDLR];
}

/* Turn the display on */
void vbDisplayOn () {
	VIP_REGS[REST] = 0;
	VIP_REGS[XPCTRL] = VIP_REGS[XPSTTS] | 2;
	VIP_REGS[DPCTRL] = VIP_REGS[DPSTTS] | 0x0302;
	VIP_REGS[FRMCYC] = 0;
	VIP_REGS[INTCLR] = VIP_REGS[INTPND];
	while (!(VIP_REGS[DPSTTS] & 0x3C));  //required?

	VIP_REGS[BRTA]  = 0;
	VIP_REGS[BRTB]  = 0;
	VIP_REGS[BRTC]  = 0;
	VIP_REGS[GPLT0] = 0xE4;	/* Set all eight palettes to: 11100100 */
	VIP_REGS[GPLT1] = 0xE4;	/* (i.e. "Normal" dark to light progression.) */
	VIP_REGS[GPLT2] = 0xE4;
	VIP_REGS[GPLT3] = 0xE4;
	VIP_REGS[JPLT0] = 0xE4;
	VIP_REGS[JPLT1] = 0xE4;
	VIP_REGS[JPLT2] = 0xE4;
	VIP_REGS[JPLT3] = 0xE4;
	VIP_REGS[BKCOL] = 0;	/* Clear the screen to black before rendering */
}

static BYTE colTable[128] = {
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xe0, 0xbc,
	0xa6, 0x96, 0x8a, 0x82, 0x7a, 0x74, 0x6e, 0x6a,
	0x66, 0x62, 0x60, 0x5c, 0x5a, 0x58, 0x56, 0x54,
	0x52, 0x50, 0x50, 0x4e, 0x4c, 0x4c, 0x4a, 0x4a,
	0x48, 0x48, 0x46, 0x46, 0x46, 0x44, 0x44, 0x44,
	0x42, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c
};

/* Setup the default Column Table */
void vbSetColTable(void) {
	int i;

	for (i = 0; i < 128; i++) {
		COLUMN_TABLE[i] = colTable[i];
		COLUMN_TABLE[i + 0x0080] = colTable[127 - i];
		COLUMN_TABLE[i + 0x0100] = colTable[i];
		COLUMN_TABLE[i + 0x0180] = colTable[127 - i];
	}
}

/* Call this after the display is on and you want the image to show up */
void vbDisplayShow (void) {
	VIP_REGS[BRTA]  = 0x20;
	VIP_REGS[BRTB]  = 0x40;
	VIP_REGS[BRTC]  = 0x20;
}

/* Call this to hide the image; e.g. while setting things up */
void vbDisplayHide (void) {
	VIP_REGS[BRTA]  = 0;
	VIP_REGS[BRTB]  = 0;
	VIP_REGS[BRTC]  = 0;
}

/* Delay execution */
void vbWaitFrame (int count) {
	int i = 0,
		tmp;

	for (i = 0; i <= count; i++) {
		tmp = VIP_REGS[XPSTTS];
		while (tmp == VIP_REGS[XPSTTS]);
	}
}

void vbFXFadeIn (int wait) {
	int i;

	for (i = 0; i <= 32; i++) {
		vbWaitFrame(wait);
		VIP_REGS[BRTA] = i;
		VIP_REGS[BRTB] = i*2;
		VIP_REGS[BRTC] = i;
	}
}

void vbFXFadeOut (int wait) {
	int i;

	for (i = 32; i >= 0; i--) {
		vbWaitFrame(wait);
		VIP_REGS[BRTA] = i;
		VIP_REGS[BRTB] = i*2;
		VIP_REGS[BRTC] = i;
	}
}

/* Macro to set the brightness for the colors */
#define SET_BRIGHT(a,b,c)       VIP_REGS[BRTA]=a; \
                                VIP_REGS[BRTB]=b; \
                                VIP_REGS[BRTC]=c;

/* Macro to set the GPLT (BGMap palette) */
#define SET_GPLT(n,pal)         VIP_REGS[GPLT0+n]=pal;

/* Macro to set the JPLT (OBJ palette) */
#define SET_JPLT(n,pal)         VIP_REGS[JPLT0+n]=pal;


/***** Ancillary Functions *****/

// Copy a block of data from one area in memory to another.
void copymem (BYTE* dest, const BYTE* src, int num) {
	int i;
	for (i = 0; i < num; i++) dest[i] = src[i];
}

// Set each byte in a block of data to a given value.
void setmem (BYTE* dest, BYTE src, int num) {
	int i;
	for (i = 0; i < num; i++) dest[i] = src;
}

/*	Copy a block of data from one area in memory to another,
adding a given value to each byte, first.	*/
void addmem(BYTE* dest, const BYTE* src, int num, BYTE offset) {
 	int i;
	for (i = 0; i < num; i++) dest[i] = (src[i] + offset);
}

void vbTextOut (int bgmap, int col, int row, char t_string[])
/* The font must reside in Character segment 3 */
{
	int i = 0;
	int pos = row * 64 + col;
	while(t_string[i])
	{
		BGMM[(0x1000 * bgmap) + pos + i] = (HWORD)t_string[i] - 32 + 0x6000;
		i++;
	}
}

int randseed()
/* When run at startup gets a random number based on the changing CTA */
{
	int random = 1;
	int rand;
	int prevnum = 0;
	int count = 1;
	
	while (count < 30000)	//repeat through many times to make more random and to allow the CTA value to change multiple times
	{
		rand = (*(BYTE*)(0x0005F830));	//CTA
		if (random == 0)		//prevent % by zero
			random = 1;
			
		random += ((rand*count) + (count%random));	//just randomly doing stuff to the number
	
		if (rand == prevnum)		//if the CTA value doesnt change then count up
			count++;
		else
			count = 0;		//if the number does change then restart the counter
		prevnum = rand;			//keep track of the last number
	}
	return random;		//returns the random seed
}

int randnum(int seed, int randnums)
/* Returns a random number in the requested range from the random seed */
{
	return (seed%randnums);	//returns the random number
}

#endif
