/* VUEngine - Virtual Utopia Engine <http://vuengine.planetvb.com/>
 * A universal game engine for the Nintendo Virtual Boy
 *
 * Copyright (C) 2007, 2017 by Jorge Eremiev <jorgech3@gmail.com> and Christian Radke <chris@vr32.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 * LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
 * NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef ANIMATION_STATE_H_
#define ANIMATION_STATE_H_


//---------------------------------------------------------------------------------------------------------
// 												INCLUDES
//---------------------------------------------------------------------------------------------------------

#include <GameState.h>


//---------------------------------------------------------------------------------------------------------
// 												DECLARATIONS
//---------------------------------------------------------------------------------------------------------

enum AnimationSequences
{
	kAnimationSequenceRexScream,
	kAnimationSequenceRexRun,
	kAnimationSequenceBanana,
	kAnimationSequenceVertigo,
	kAnimationSequenceVolcano,
	kAnimationSequenceCredits,
};


//---------------------------------------------------------------------------------------------------------
// 											CLASS'S DECLARATION
//---------------------------------------------------------------------------------------------------------

// declare the virtual methods
#define AnimationState_METHODS(ClassName)																\
    	GameState_METHODS(ClassName)											    				    \

// declare the virtual methods which are redefined
#define AnimationState_SET_VTABLE(ClassName)															\
        GameState_SET_VTABLE(ClassName)								    								\
        __VIRTUAL_SET(ClassName, AnimationState, enter);												\
		__VIRTUAL_SET(ClassName, AnimationState, execute);												\
		__VIRTUAL_SET(ClassName, AnimationState, processUserInput);										\

__CLASS(AnimationState);

#define AnimationState_ATTRIBUTES							        									\
        GameState_ATTRIBUTES																			\
		AnimatedInGameEntity resumeButtonEntity;														\
		AnimatedInGameEntity backButtonEntity;															\
		bool isPaused;																					\
		u8 currentSequence;																				\


//---------------------------------------------------------------------------------------------------------
// 										PUBLIC INTERFACE
//---------------------------------------------------------------------------------------------------------

AnimationState AnimationState_getInstance(void);

void AnimationState_processUserInput(AnimationState this, UserInput userInput);
void AnimationState_execute(AnimationState this, void* owner);
void AnimationState_playBanana(AnimationState this);
void AnimationState_playRexRun(AnimationState this);
void AnimationState_playVertigo(AnimationState this);
void AnimationState_playVolcanoEnd(AnimationState this);
void AnimationState_playCreditsAnimation(AnimationState this);
void AnimationState_playCreditsText(AnimationState this);


#endif
