#!/usr/bin/python
import sys
import getopt
import os
import struct
from itertools import groupby

def main(argv):
    try:
        opts, args = getopt.getopt(argv, "h:f")
    except getopt.GetoptError:
        Usage()
        sys.exit(2)
    for o, a in opts:
        if o == "-h":
            Usage()
            sys.exit()
        elif o == "-f":
            if len(argv) < 2:
                print "Not enough arguments supplied for -f"
                sys.exit(2)
            Compress_BGMAP(argv[1])
    Usage()
    sys.exit()

def Usage():
    print "VBDream BGMAP RLE Compressor v0_0"
    print "Copyright (c) Kresna 2019\n"
    print "Options:"
    print "  -f BGMAP_NAME"
    print "     Compress the BGMAP using RLE compression"

def Compress_BGMAP(FILE_NAME):
    mapfile = open(FILE_NAME, "r+b")
    count = 0
    mapdata = []
    mapdataindex = 0
    if os.path.getsize(FILE_NAME) != 0x2000:
        print "-", FILE_NAME, "Map does not need compression."
        sys.exit()
    while count < 0x2000:
        mapdata += struct.unpack("<I", mapfile.read(4))
        count += 4
    # straight outta stack overflow lmao I got no time for this
    compressedmap = [(k, sum(1 for _ in g)) for k,g in groupby(mapdata)]
    mapfile.seek(0)
    count = 0
    mapfile.write(struct.pack("<H", len(compressedmap)))
    while count < len(compressedmap):
        mapfile.write(struct.pack("<I", compressedmap[count][0]))
        mapfile.write(struct.pack("<H", compressedmap[count][1]))
        count += 1
    mapfile.truncate()
    mapfile.close
    print "+", FILE_NAME, "Map was successfully compressed. Size:", len(compressedmap)*6+2, "bytes"
    sys.exit()

if __name__ == "__main__":
    main(sys.argv[1:])
