#!/usr/bin/python
import sys
import getopt
import os
import struct

def main(argv):
    try:
        opts, args = getopt.getopt(argv, "h:f")
    except getopt.GetoptError:
        Usage()
        sys.exit(2)
    for o, a in opts:
        if o == "-h":
            Usage()
            sys.exit()
        elif o == "-f":
            if len(argv) < 3:
                print "Not enough arguments supplied for -f"
                sys.exit(2)
            Change_Palette(argv[1], argv[2])
    Usage()
    sys.exit()

def Usage():
    print "VBDream BGMAP Palette Selector v0_0"
    print "Copyright (c) Kresna 2019\n"
    print "Options:"
    print "  -f BGMAP_NAME [0-3]"
    print "     Change the palette of the map to the selected  palette."

def Change_Palette(FILE_NAME, PALETTE_NUMBER):
    mapfile = open(FILE_NAME, "r+b")
    count = 0
    while count < 0x2000:
        count += 1
        mapfile.seek(count)
        highbyte = struct.unpack("B", mapfile.read(1))[0]
        highbyte = highbyte & 0b00111111
        highbyte = highbyte | (int(PALETTE_NUMBER) << 6)
        mapfile.seek(count)
        mapfile.write(struct.pack('B', highbyte))
        count += 1
    sys.exit()

if __name__ == "__main__":
    main(sys.argv[1:])
